
// 81 Controller-1 RS232 RS485  I2C Configuration
//
// Microchip MCU: PIC18F46K22-I/MV
//
// PCF8574A IO expander chip (I2C)
//
// G. Graves 8/18/2019
// Graves Electronics, LLC
//
// For: Microchip XC8 C compiler C language
//
// 81 Controller Board Crystal, 11.0592Mhz
//
//
//
//
// Setup for UART-1 and UART-2, RS232 and RS485
//
// Setup for current modules using I2C
//
// Includes Setup information for SPI
//
//
// ********************************************
// *This is Sample Code, No Warranties Implied*
// ********************************************
//
//
//
//**************************************************************

// Board Specific information:
//
//
//I/O Line with Analog Switches:
//
// RA0 = IO-0
// RA1 = IO-1
// RA2 = IO-2
// RA3 = IO-3
// RA5 = IO-4
// RB0 = IO-5  (INT0 input line)
// RB1 = IO-6  (INT1 input line)
// RB2 = IO-7  (INT2 input line)
//
// Set All Inputs for standard setup when pull-ups are ""ON"
// with Buffers
//
// Set All as Outputs as standard setup when pull-ups are "OFF"
// and No Buffers
//
// Or, connect pull-up resistors to connector and configure all
//     as inputs. 
//  
// DS2 = "ON" POSITION = Pulled Up Buffer mode
//
//------------------------------------------------
//
// Relay Drivers, outputs
//
// RD5 = RY1 driver
// RE1 = RY2 driver
// RE2 = RY3 driver
// RA4 = RY4 driver
//
//------------------------------------------------
//
// DS1, Mode data input Dip switch, inputs
//
// RE0 = DS1-0
// RB3 = DS1-1
// RB4 = DS1-2
// RB5 = DS1-3
//
//-------------------------------------------------
// Expansion Modules, SPI lines
//
//
//(Make outputs when unused)
// SCK2,(RD0)(output)        =    SCK on module (input)
// SDO2,(RD4)(output)        =    SDI on module (input)
// SDI2,(RD1)(input)         =    SDO on module (output)
// RC0 (output)              =    /CS1 on module (input) 
// RC1 (output)              =    /CS2 on module (input) 
// RC3 (output)              =    Ctrl-1 on module (input)
// RC2 (output)              =    Ctrl-2 on module (input) 
// RD2 (output)              =    Ctrl-3 on module (input)
// RD3-/SS2 (output)         =    /SS2-Spare on module (input)
//
//--------------------------------------------------
//
// Communications I/O lines:
//
// TX2 (RD6) = Output, RS232
// RX2 (RD7) = Input, RS232
//
// TX1 (RC6) = Output, RS485
// RX1 (RC7) = Input, RS485
//
// RC5       = Output, RS485 RCVR Enable
//
// RC4       = Output, RS485 Driver Enable
//
//---------------------------------------------------


// TRISx registers: 0 = Output, 1 = Input
//
//
// TRISA =  X X 0 0 0 0 0 0 b  , RA6 and RA7 = OSC pins
//
//
// TRISB =  0 0 1 1 1 0 0 0 b  , RB6 = PGC and RB7 = PGD
//
//
// TRISC =  1 0 0 0 0 0 0 0 b
//
//
// TRISD =  1 0 0 0 0 0 1 0 b
//
//
// TRISE =  X X X X 1 0 0 1 b , RE3 = /MCLR
//
//
//-------------------------------------------------------



// **** Include Libraries Here *****

#include <stdio.h>
#include <stdlib.h>
#include <xc.h>
#include <stdarg.h>
#include <string.h>
 

 



// *** Configurations ************************************************
//
// For PIC18F46K22

#pragma config WDTEN = OFF    // turn off watchdog timer, turn on for product launch

#pragma config WDTPS = 1      // Watchdog Timer Postscale Select bits

#pragma config IESO = OFF     // Oscillator Switchover mode disabled

#pragma config FOSC = HSMP    // HS oscillator

#pragma config PRICLKEN = ON  // Primary clock is always enabled

#pragma config PLLCFG = OFF   // 4x PLL, Oscillator used directly

#pragma config BOREN = NOSLP  //Brown-out Reset enabled in 
                              //hardware only and disabled 
                              //in Sleep mode (SBOREN is disabled)

#pragma config BORV = 285 	    //VBOR set to 2.85 V nominal, Brownout setting

#pragma config PWRTEN = OFF     //Power up timer Disabled

#pragma config P2BMX = PORTC0   //P2B is on RC0

#pragma config CCP2MX = PORTC1  //CCP2 input/output is multiplexed with RC1

#pragma config PBADEN = OFF	    //PORTB<5:0> pins are configured as digital I/O on Reset

#pragma config CCP3MX = PORTE0   //P3A/CCP3 input/output is mulitplexed with RE0 

#pragma config MCLRE = EXTMCLR 	//MCLR pin enabled, RE3 input pin disabled

#pragma config HFOFST = OFF	     //HFINTOSC output and ready status are delayed by the 
                                 //oscillator stable status

#pragma config T3CMX = PORTC0    //T3CKI is on RC0

//#pragma config DEBUG = OFF	     //DEBUG is : Disabled *** OFF OPTION ***

#pragma config DEBUG = ON	     //DEBUG is : Enabled

#pragma config STVREN = OFF	     //Stack full/underflow will not cause Reset

#pragma config XINST = OFF      //Instruction set extension and Indexed Addressing mode disabled

#pragma config LVP = OFF	    //Single-Supply ICSP enabled if MCLRE is also 1	, must be OFF for Debugging Microchip PICKIT

#pragma config CP0 = OFF        //Block 0 (000800-003FFFh) not code-protected

#pragma config CP1 = OFF        //Block 1 (004000-007FFFh) not code-protected

#pragma config CP2 = OFF        //Block 2 (008000-00BFFFh) not code-protected

#pragma config CP3 = OFF        //Block 3 (00C000-00FFFFh) not code-protected

#pragma config CPD = OFF        //Data EEPROM not code-protected

#pragma config CPB = OFF        //Boot block (000000-0007FFh) not code-protected

#pragma config WRT0 = OFF       //Block 0 (000800-003FFFh) not write-protected

#pragma config WRT1 = OFF       //Block 1 (004000-007FFFh) not write-protected

#pragma config WRT2 = OFF       //Block 2 (008000-00BFFFh) not write-protected

#pragma config WRT3 = OFF       //Block 3 (00C000-00FFFFh) not write-protected

#pragma config WRTB = OFF       //Boot Block (000000-0007FFh) not write-protected

#pragma config WRTC = OFF       //Configuration registers (300000-3000FFh) not write-protected

#pragma config WRTD = OFF       //Data EEPROM not write-protected 

#pragma config EBTR0 = OFF      //Block 0 (000800-003FFFh) not protected from table reads executed in other blocks

#pragma config EBTR1 = OFF      //Block 1 (004000-007FFFh) not protected from table reads executed in other blocks

#pragma config EBTR2 = OFF      //Block 2 (008000-00BFFFh) not protected from table reads executed in other blocks

#pragma config EBTR3 = OFF      //Block 3 (00C000-00FFFFh) not protected from table reads executed in other blocks

#pragma config EBTRB = OFF      //Boot Block (000000-0007FFh) not protected from table reads executed in other blocks


// Board Crystal ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


#define _XTAL_FREQ 11059200       // Define XTAL OSC Frequency, 11.0592Mhz  
                                  // Need for _delay(n) and __delay_ms(n)
                                  // type macros



//  FUNCTIONS, Define Funtions for Compiler here +++++++++++++++++++++









//----  MAIN program body loop  -------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

void main(void)
{

    // Set up MCU I/O Lines;


     TRISA = 0b11101111;           // TRISA =  1 1 1 0 1 1 1 1 b  , RA6 and RA7 = OSC pins

     TRISB = 0b00111111;           // TRISB =  0 0 1 1 1 1 1 1 b  , RB6 = PGC and RB7 = PGD

     TRISC = 0b10001100;           // TRISC =  1 0 0 0 0 0 0 0 b  , RC7 = Input = RX1 , RC6 = output = TX1, RC4,5 = outputs
                                   //
                                   //  RC3 = (Ctrl-1) an Input for IO Expander /Int-1 read
                                   //  RC2 = (Ctrl-2) an Input for IO Exapander /Int-2 read
    
    
     TRISD = 0b10000011;           // TRISD =  1 0 0 0 0 0 1 1 b  , *** RD1 = Input for SPI module use, RD0 = SCK output, SPI
                                   //                                   RD0 and RD1 must be inputs for I2C


     TRISE = 0b00001001;           // TRISE =  X X X X 1 0 0 1 b , RE3 = /MCLR


   // Set up MCU I/O lines for Digital/Analog;
   // 
   // These are set to Analog on RESET (ANSELx = 0ffh) , Digital Inputs will read as "0"
   // if input is set as Analog. Set to Analog so CMOS inputs don't float ( 1 = Analog, 0 = Digital )   

      ANSELA = 0b11000000;        // PortA ANSEL

      ANSELB = 0b11000000;        // PortB ANSEL, RB3,RB4,RB5 Digital inputs

      ANSELC = 0b01000000;        // PortC ANSEL, RC7 = Digital input      

      ANSELD = 0b00000000;        // PortD  ANSEL, RD1,RD7 = Digital input

      ANSELE = 0b11111000;        // PortE ANSEL, RE0 = Digital input 
   


   // Setup MCU SPI unit;  Set for Master Mode,  Clock = FOSC/16 
   //  Clock Polartity, CKE=1, CKP=0 *** OFF ***
    
    //SSP2STAT = 0b11000000;         // Set SSP2STAT, CKE=Bit-6 = 1, SMP=1

    //SSP2CON1 = 0b00100001;         // Set SSP2CON1, CKP=Bit-4 = 0, Fosc/16 
  
    //SSP2CON3 = 0b00000000;         // Set SSP2CON3




   // Setup MCU I2C unit;  Set for Master Mode

   // TI PCF8574A IO expander chip, or NXP version
 
   // Max. clock speed PCF8574A IO expander chip is 100kHz
   // A0,1,2 line on chip set to 0, grounded
   // 
   // Write Address =  112 (dec), 70 (hex)
   // Read Address =   113 (dec), 71 (hex)



      SSP2STAT = 0b10000000;

      SSP2CON1 = 0b00101000;         // Synchronous Serial Port Enable, I2C Master Mode
                                     // I2C Master mode, clock = FOSC / (4 * (SSPxADD+1))
      
      SSP2ADD = 0x20;                // I2C clock rate = 83.78kHz, SSP2ADD <--- 32 decimal

      SSP2CON2 = 0b00000000;         // ACKEN = 0

 
      SSP2CON3 = 0b00011000;          // 300nSec hold time



  // Setup UART #1 for RS485 comm.-------------------------------------


    TXSTA1 = 0b10000001;          // SPEN = 1, BRGH = 0, SYNC = 0,

    RCSTA1 = 0b10000000;          // 

    RCSTA1bits.CREN = 1;          // CREN = 1, enable RCVR via bit-4

    BAUDCON1 = 0b00000000;        // BRG16 = 0
 
    SPBRG1 = 0x47;                // Set Baud rate for 2400 bps
 
   //SPBRG1 = 143;                   // Temp 1200 bps *** slower option ***

  

  // Setup UART #2 for RS232 comm.-------------------------------------


    TXSTA2 = 0b10000001;          // SPEN = 1, BRGH = 0, SYNC = 0,

    RCSTA2 = 0b10000000;          // 

    RCSTA2bits.CREN = 1;          // CREN = 1, enable RCVR via bit-4 

    BAUDCON2 = 0b00000000;        // BRG16 = 0
 
    SPBRG2 = 0x47;                // Set Baud rate for 2400 bps
 
   //SPBRG2 = 143;                   // Temp 1200 bps

  // --------------------------------------------------------------------  

  

  
 






  //--------------------------------------

                //*******************************************************
    while(1)    // Define idle loop *************************************
    {

   
     // Main Idle Loop code goes here


        //CLRWDT();   // ## WDT is off for testing and debugging ##


        
        
        
        
        
        
        
        
        



     }// end while ****************************************************
                     
            

}// end main


// ------ End Main Program Loop -----------------------------------
// ----------------------------------------------------------------
// ----------------------------------------------------------------


//  *********** FUNCTIONS DOWN HERE **************


//  **********************************************
